package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{CaseId, CaseArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateCaseResponse(caseArn: CaseArn, caseId: CaseId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateCaseResponse = {
    import CreateCaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateCaseResponse
      .builder()
      .caseArn(CaseArn.unwrap(caseArn): java.lang.String)
      .caseId(CaseId.unwrap(caseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateCaseResponse.ReadOnly =
    zio.aws.connectcases.model.CreateCaseResponse.wrap(buildAwsValue())
}
object CreateCaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateCaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateCaseResponse =
      zio.aws.connectcases.model.CreateCaseResponse(caseArn, caseId)
    def caseArn: CaseArn
    def caseId: CaseId
    def getCaseArn: ZIO[Any, Nothing, CaseArn] = ZIO.succeed(caseArn)
    def getCaseId: ZIO[Any, Nothing, CaseId] = ZIO.succeed(caseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateCaseResponse
  ) extends zio.aws.connectcases.model.CreateCaseResponse.ReadOnly {
    override val caseArn: CaseArn =
      zio.aws.connectcases.model.primitives.CaseArn(impl.caseArn())
    override val caseId: CaseId =
      zio.aws.connectcases.model.primitives.CaseId(impl.caseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateCaseResponse
  ): zio.aws.connectcases.model.CreateCaseResponse.ReadOnly = new Wrapper(impl)
}
