package zio.aws.connectcases.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcases.model.primitives.{
  SearchCasesRequestSearchTermString,
  NextToken,
  SearchCasesRequestMaxResultsInteger,
  DomainId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchCasesRequest(
    domainId: DomainId,
    fields: Optional[Iterable[zio.aws.connectcases.model.FieldIdentifier]] =
      Optional.Absent,
    filter: Optional[zio.aws.connectcases.model.CaseFilter] = Optional.Absent,
    maxResults: Optional[SearchCasesRequestMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    searchTerm: Optional[SearchCasesRequestSearchTermString] = Optional.Absent,
    sorts: Optional[Iterable[zio.aws.connectcases.model.Sort]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.SearchCasesRequest = {
    import SearchCasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.SearchCasesRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        fields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fields)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value =>
          SearchCasesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        searchTerm.map(value =>
          SearchCasesRequestSearchTermString.unwrap(value): java.lang.String
        )
      )(_.searchTerm)
      .optionallyWith(
        sorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sorts)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.SearchCasesRequest.ReadOnly =
    zio.aws.connectcases.model.SearchCasesRequest.wrap(buildAwsValue())
}
object SearchCasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.SearchCasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.SearchCasesRequest =
      zio.aws.connectcases.model.SearchCasesRequest(
        domainId,
        fields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        searchTerm.map(value => value),
        sorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainId: DomainId
    def fields
        : Optional[List[zio.aws.connectcases.model.FieldIdentifier.ReadOnly]]
    def filter: Optional[zio.aws.connectcases.model.CaseFilter.ReadOnly]
    def maxResults: Optional[SearchCasesRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def searchTerm: Optional[SearchCasesRequestSearchTermString]
    def sorts: Optional[List[zio.aws.connectcases.model.Sort.ReadOnly]]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFields: ZIO[Any, AwsError, List[
      zio.aws.connectcases.model.FieldIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("fields", fields)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.connectcases.model.CaseFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, SearchCasesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSearchTerm: ZIO[Any, AwsError, SearchCasesRequestSearchTermString] =
      AwsError.unwrapOptionField("searchTerm", searchTerm)
    def getSorts
        : ZIO[Any, AwsError, List[zio.aws.connectcases.model.Sort.ReadOnly]] =
      AwsError.unwrapOptionField("sorts", sorts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.SearchCasesRequest
  ) extends zio.aws.connectcases.model.SearchCasesRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val fields
        : Optional[List[zio.aws.connectcases.model.FieldIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.FieldIdentifier.wrap(item)
          }.toList
        )
    override val filter
        : Optional[zio.aws.connectcases.model.CaseFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.connectcases.model.CaseFilter.wrap(value))
    override val maxResults: Optional[SearchCasesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.connectcases.model.primitives
            .SearchCasesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
    override val searchTerm: Optional[SearchCasesRequestSearchTermString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchTerm())
        .map(value =>
          zio.aws.connectcases.model.primitives
            .SearchCasesRequestSearchTermString(value)
        )
    override val sorts
        : Optional[List[zio.aws.connectcases.model.Sort.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.Sort.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.SearchCasesRequest
  ): zio.aws.connectcases.model.SearchCasesRequest.ReadOnly = new Wrapper(impl)
}
