package zio.aws.connectcases.model
import scala.jdk.CollectionConverters.*
sealed trait Order {
  def unwrap: software.amazon.awssdk.services.connectcases.model.Order
}
object Order {
  def wrap(
      value: software.amazon.awssdk.services.connectcases.model.Order
  ): zio.aws.connectcases.model.Order = value match {
    case software.amazon.awssdk.services.connectcases.model.Order.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connectcases.model.Order.ASC =>
      val r = Asc
      r
    case software.amazon.awssdk.services.connectcases.model.Order.DESC =>
      val r = Desc
      r
  }
  case object unknownToSdkVersion extends zio.aws.connectcases.model.Order {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.Order =
      software.amazon.awssdk.services.connectcases.model.Order.UNKNOWN_TO_SDK_VERSION
  }
  case object Asc extends zio.aws.connectcases.model.Order {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.Order =
      software.amazon.awssdk.services.connectcases.model.Order.ASC
  }
  case object Desc extends zio.aws.connectcases.model.Order {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.Order =
      software.amazon.awssdk.services.connectcases.model.Order.DESC
  }
}
