package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLayoutsResponse(
    layouts: Iterable[zio.aws.connectcases.model.LayoutSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse = {
    import ListLayoutsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse
      .builder()
      .layouts(layouts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ListLayoutsResponse.ReadOnly =
    zio.aws.connectcases.model.ListLayoutsResponse.wrap(buildAwsValue())
}
object ListLayoutsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListLayoutsResponse =
      zio.aws.connectcases.model.ListLayoutsResponse(
        layouts.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def layouts: List[zio.aws.connectcases.model.LayoutSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getLayouts: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.LayoutSummary.ReadOnly
    ]] = ZIO.succeed(layouts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse
  ) extends zio.aws.connectcases.model.ListLayoutsResponse.ReadOnly {
    override val layouts
        : List[zio.aws.connectcases.model.LayoutSummary.ReadOnly] = impl
      .layouts()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.LayoutSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse
  ): zio.aws.connectcases.model.ListLayoutsResponse.ReadOnly = new Wrapper(impl)
}
