package zio.aws.connectcases.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcases.model.primitives.{
  NextToken,
  DomainId,
  Value,
  FieldId,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFieldOptionsRequest(
    domainId: DomainId,
    fieldId: FieldId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    values: Optional[Iterable[Value]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest = {
    import ListFieldOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .fieldId(FieldId.unwrap(fieldId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            Value.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ListFieldOptionsRequest.ReadOnly =
    zio.aws.connectcases.model.ListFieldOptionsRequest.wrap(buildAwsValue())
}
object ListFieldOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListFieldOptionsRequest =
      zio.aws.connectcases.model.ListFieldOptionsRequest(
        domainId,
        fieldId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        values.map(value => value)
      )
    def domainId: DomainId
    def fieldId: FieldId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def values: Optional[List[Value]]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFieldId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(fieldId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getValues: ZIO[Any, AwsError, List[Value]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest
  ) extends zio.aws.connectcases.model.ListFieldOptionsRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val fieldId: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.fieldId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connectcases.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
    override val values: Optional[List[Value]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connectcases.model.primitives.Value(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest
  ): zio.aws.connectcases.model.ListFieldOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
