package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDomainsResponse(
    domains: Iterable[zio.aws.connectcases.model.DomainSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListDomainsResponse = {
    import ListDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListDomainsResponse
      .builder()
      .domains(domains.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ListDomainsResponse.ReadOnly =
    zio.aws.connectcases.model.ListDomainsResponse.wrap(buildAwsValue())
}
object ListDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListDomainsResponse =
      zio.aws.connectcases.model.ListDomainsResponse(
        domains.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def domains: List[zio.aws.connectcases.model.DomainSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDomains: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.DomainSummary.ReadOnly
    ]] = ZIO.succeed(domains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListDomainsResponse
  ) extends zio.aws.connectcases.model.ListDomainsResponse.ReadOnly {
    override val domains
        : List[zio.aws.connectcases.model.DomainSummary.ReadOnly] = impl
      .domains()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.DomainSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListDomainsResponse
  ): zio.aws.connectcases.model.ListDomainsResponse.ReadOnly = new Wrapper(impl)
}
