package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{LayoutName, LayoutId, LayoutArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LayoutSummary(
    layoutArn: LayoutArn,
    layoutId: LayoutId,
    name: LayoutName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.LayoutSummary = {
    import LayoutSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.LayoutSummary
      .builder()
      .layoutArn(LayoutArn.unwrap(layoutArn): java.lang.String)
      .layoutId(LayoutId.unwrap(layoutId): java.lang.String)
      .name(LayoutName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.LayoutSummary.ReadOnly =
    zio.aws.connectcases.model.LayoutSummary.wrap(buildAwsValue())
}
object LayoutSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.LayoutSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.LayoutSummary =
      zio.aws.connectcases.model.LayoutSummary(layoutArn, layoutId, name)
    def layoutArn: LayoutArn
    def layoutId: LayoutId
    def name: LayoutName
    def getLayoutArn: ZIO[Any, Nothing, LayoutArn] = ZIO.succeed(layoutArn)
    def getLayoutId: ZIO[Any, Nothing, LayoutId] = ZIO.succeed(layoutId)
    def getName: ZIO[Any, Nothing, LayoutName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.LayoutSummary
  ) extends zio.aws.connectcases.model.LayoutSummary.ReadOnly {
    override val layoutArn: LayoutArn =
      zio.aws.connectcases.model.primitives.LayoutArn(impl.layoutArn())
    override val layoutId: LayoutId =
      zio.aws.connectcases.model.primitives.LayoutId(impl.layoutId())
    override val name: LayoutName =
      zio.aws.connectcases.model.primitives.LayoutName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.LayoutSummary
  ): zio.aws.connectcases.model.LayoutSummary.ReadOnly = new Wrapper(impl)
}
