package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{LayoutName, LayoutId, LayoutArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLayoutResponse(
    content: zio.aws.connectcases.model.LayoutContent,
    layoutArn: LayoutArn,
    layoutId: LayoutId,
    name: LayoutName,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetLayoutResponse = {
    import GetLayoutResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetLayoutResponse
      .builder()
      .content(content.buildAwsValue())
      .layoutArn(LayoutArn.unwrap(layoutArn): java.lang.String)
      .layoutId(LayoutId.unwrap(layoutId): java.lang.String)
      .name(LayoutName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetLayoutResponse.ReadOnly =
    zio.aws.connectcases.model.GetLayoutResponse.wrap(buildAwsValue())
}
object GetLayoutResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetLayoutResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetLayoutResponse =
      zio.aws.connectcases.model.GetLayoutResponse(
        content.asEditable,
        layoutArn,
        layoutId,
        name,
        tags.map(value => value)
      )
    def content: zio.aws.connectcases.model.LayoutContent.ReadOnly
    def layoutArn: LayoutArn
    def layoutId: LayoutId
    def name: LayoutName
    def tags: Optional[Map[String, String]]
    def getContent
        : ZIO[Any, Nothing, zio.aws.connectcases.model.LayoutContent.ReadOnly] =
      ZIO.succeed(content)
    def getLayoutArn: ZIO[Any, Nothing, LayoutArn] = ZIO.succeed(layoutArn)
    def getLayoutId: ZIO[Any, Nothing, LayoutId] = ZIO.succeed(layoutId)
    def getName: ZIO[Any, Nothing, LayoutName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetLayoutResponse
  ) extends zio.aws.connectcases.model.GetLayoutResponse.ReadOnly {
    override val content: zio.aws.connectcases.model.LayoutContent.ReadOnly =
      zio.aws.connectcases.model.LayoutContent.wrap(impl.content())
    override val layoutArn: LayoutArn =
      zio.aws.connectcases.model.primitives.LayoutArn(impl.layoutArn())
    override val layoutId: LayoutId =
      zio.aws.connectcases.model.primitives.LayoutId(impl.layoutId())
    override val name: LayoutName =
      zio.aws.connectcases.model.primitives.LayoutName(impl.name())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetLayoutResponse
  ): zio.aws.connectcases.model.GetLayoutResponse.ReadOnly = new Wrapper(impl)
}
