package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{
  FieldName,
  FieldId,
  FieldArn,
  FieldDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFieldResponse(
    description: Optional[FieldDescription] = Optional.Absent,
    fieldArn: FieldArn,
    fieldId: FieldId,
    name: FieldName,
    namespace: zio.aws.connectcases.model.FieldNamespace,
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: zio.aws.connectcases.model.FieldType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetFieldResponse = {
    import GetFieldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetFieldResponse
      .builder()
      .optionallyWith(
        description.map(value =>
          FieldDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .fieldArn(FieldArn.unwrap(fieldArn): java.lang.String)
      .fieldId(FieldId.unwrap(fieldId): java.lang.String)
      .name(FieldName.unwrap(name): java.lang.String)
      .namespace(namespace.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetFieldResponse.ReadOnly =
    zio.aws.connectcases.model.GetFieldResponse.wrap(buildAwsValue())
}
object GetFieldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetFieldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetFieldResponse =
      zio.aws.connectcases.model.GetFieldResponse(
        description.map(value => value),
        fieldArn,
        fieldId,
        name,
        namespace,
        tags.map(value => value),
        `type`
      )
    def description: Optional[FieldDescription]
    def fieldArn: FieldArn
    def fieldId: FieldId
    def name: FieldName
    def namespace: zio.aws.connectcases.model.FieldNamespace
    def tags: Optional[Map[String, String]]
    def `type`: zio.aws.connectcases.model.FieldType
    def getDescription: ZIO[Any, AwsError, FieldDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFieldArn: ZIO[Any, Nothing, FieldArn] = ZIO.succeed(fieldArn)
    def getFieldId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(fieldId)
    def getName: ZIO[Any, Nothing, FieldName] = ZIO.succeed(name)
    def getNamespace
        : ZIO[Any, Nothing, zio.aws.connectcases.model.FieldNamespace] =
      ZIO.succeed(namespace)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.connectcases.model.FieldType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetFieldResponse
  ) extends zio.aws.connectcases.model.GetFieldResponse.ReadOnly {
    override val description: Optional[FieldDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.connectcases.model.primitives.FieldDescription(value)
      )
    override val fieldArn: FieldArn =
      zio.aws.connectcases.model.primitives.FieldArn(impl.fieldArn())
    override val fieldId: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.fieldId())
    override val name: FieldName =
      zio.aws.connectcases.model.primitives.FieldName(impl.name())
    override val namespace: zio.aws.connectcases.model.FieldNamespace =
      zio.aws.connectcases.model.FieldNamespace.wrap(impl.namespace())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: zio.aws.connectcases.model.FieldType =
      zio.aws.connectcases.model.FieldType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetFieldResponse
  ): zio.aws.connectcases.model.GetFieldResponse.ReadOnly = new Wrapper(impl)
}
