package zio.aws.connectcases.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcases.model.primitives.{
  DomainName,
  DomainId,
  DomainArn,
  CreatedTime
}
import scala.jdk.CollectionConverters.*
final case class GetDomainResponse(
    createdTime: CreatedTime,
    domainArn: DomainArn,
    domainId: DomainId,
    domainStatus: zio.aws.connectcases.model.DomainStatus,
    name: DomainName,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetDomainResponse = {
    import GetDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetDomainResponse
      .builder()
      .createdTime(CreatedTime.unwrap(createdTime): Instant)
      .domainArn(DomainArn.unwrap(domainArn): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .domainStatus(domainStatus.unwrap)
      .name(DomainName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetDomainResponse.ReadOnly =
    zio.aws.connectcases.model.GetDomainResponse.wrap(buildAwsValue())
}
object GetDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetDomainResponse =
      zio.aws.connectcases.model.GetDomainResponse(
        createdTime,
        domainArn,
        domainId,
        domainStatus,
        name,
        tags.map(value => value)
      )
    def createdTime: CreatedTime
    def domainArn: DomainArn
    def domainId: DomainId
    def domainStatus: zio.aws.connectcases.model.DomainStatus
    def name: DomainName
    def tags: Optional[Map[String, String]]
    def getCreatedTime: ZIO[Any, Nothing, CreatedTime] =
      ZIO.succeed(createdTime)
    def getDomainArn: ZIO[Any, Nothing, DomainArn] = ZIO.succeed(domainArn)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getDomainStatus
        : ZIO[Any, Nothing, zio.aws.connectcases.model.DomainStatus] =
      ZIO.succeed(domainStatus)
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetDomainResponse
  ) extends zio.aws.connectcases.model.GetDomainResponse.ReadOnly {
    override val createdTime: CreatedTime =
      zio.aws.connectcases.model.primitives.CreatedTime(impl.createdTime())
    override val domainArn: DomainArn =
      zio.aws.connectcases.model.primitives.DomainArn(impl.domainArn())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val domainStatus: zio.aws.connectcases.model.DomainStatus =
      zio.aws.connectcases.model.DomainStatus.wrap(impl.domainStatus())
    override val name: DomainName =
      zio.aws.connectcases.model.primitives.DomainName(impl.name())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetDomainResponse
  ): zio.aws.connectcases.model.GetDomainResponse.ReadOnly = new Wrapper(impl)
}
