package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.DomainId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDomainRequest(domainId: DomainId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetDomainRequest = {
    import GetDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetDomainRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetDomainRequest.ReadOnly =
    zio.aws.connectcases.model.GetDomainRequest.wrap(buildAwsValue())
}
object GetDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetDomainRequest =
      zio.aws.connectcases.model.GetDomainRequest(domainId)
    def domainId: DomainId
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetDomainRequest
  ) extends zio.aws.connectcases.model.GetDomainRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetDomainRequest
  ): zio.aws.connectcases.model.GetDomainRequest.ReadOnly = new Wrapper(impl)
}
