package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{TemplateId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCaseResponse(
    fields: Iterable[zio.aws.connectcases.model.FieldValue],
    nextToken: Optional[NextToken] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetCaseResponse = {
    import GetCaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetCaseResponse
      .builder()
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetCaseResponse.ReadOnly =
    zio.aws.connectcases.model.GetCaseResponse.wrap(buildAwsValue())
}
object GetCaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetCaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetCaseResponse =
      zio.aws.connectcases.model.GetCaseResponse(
        fields.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        tags.map(value => value),
        templateId
      )
    def fields: List[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def nextToken: Optional[NextToken]
    def tags: Optional[Map[String, String]]
    def templateId: TemplateId
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldValue.ReadOnly
    ]] = ZIO.succeed(fields)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetCaseResponse
  ) extends zio.aws.connectcases.model.GetCaseResponse.ReadOnly {
    override val fields: List[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      impl
        .fields()
        .asScala
        .map { item =>
          zio.aws.connectcases.model.FieldValue.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetCaseResponse
  ): zio.aws.connectcases.model.GetCaseResponse.ReadOnly = new Wrapper(impl)
}
