package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{NextToken, DomainId, CaseId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCaseRequest(
    caseId: CaseId,
    domainId: DomainId,
    fields: Iterable[zio.aws.connectcases.model.FieldIdentifier],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetCaseRequest = {
    import GetCaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetCaseRequest
      .builder()
      .caseId(CaseId.unwrap(caseId): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetCaseRequest.ReadOnly =
    zio.aws.connectcases.model.GetCaseRequest.wrap(buildAwsValue())
}
object GetCaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetCaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetCaseRequest =
      zio.aws.connectcases.model.GetCaseRequest(
        caseId,
        domainId,
        fields.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def caseId: CaseId
    def domainId: DomainId
    def fields: List[zio.aws.connectcases.model.FieldIdentifier.ReadOnly]
    def nextToken: Optional[NextToken]
    def getCaseId: ZIO[Any, Nothing, CaseId] = ZIO.succeed(caseId)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldIdentifier.ReadOnly
    ]] = ZIO.succeed(fields)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetCaseRequest
  ) extends zio.aws.connectcases.model.GetCaseRequest.ReadOnly {
    override val caseId: CaseId =
      zio.aws.connectcases.model.primitives.CaseId(impl.caseId())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val fields
        : List[zio.aws.connectcases.model.FieldIdentifier.ReadOnly] = impl
      .fields()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.FieldIdentifier.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetCaseRequest
  ): zio.aws.connectcases.model.GetCaseRequest.ReadOnly = new Wrapper(impl)
}
