package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{FieldOptionValue, FieldOptionName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FieldOption(
    active: Boolean,
    name: FieldOptionName,
    value: FieldOptionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldOption = {
    import FieldOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldOption
      .builder()
      .active(active: java.lang.Boolean)
      .name(FieldOptionName.unwrap(name): java.lang.String)
      .value(FieldOptionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldOption.ReadOnly =
    zio.aws.connectcases.model.FieldOption.wrap(buildAwsValue())
}
object FieldOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldOption =
      zio.aws.connectcases.model.FieldOption(active, name, value)
    def active: Boolean
    def name: FieldOptionName
    def value: FieldOptionValue
    def getActive: ZIO[Any, Nothing, Boolean] = ZIO.succeed(active)
    def getName: ZIO[Any, Nothing, FieldOptionName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, FieldOptionValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldOption
  ) extends zio.aws.connectcases.model.FieldOption.ReadOnly {
    override val active: Boolean = impl.active(): Boolean
    override val name: FieldOptionName =
      zio.aws.connectcases.model.primitives.FieldOptionName(impl.name())
    override val value: FieldOptionValue =
      zio.aws.connectcases.model.primitives.FieldOptionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldOption
  ): zio.aws.connectcases.model.FieldOption.ReadOnly = new Wrapper(impl)
}
