package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{LayoutId, LayoutArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateLayoutResponse(
    layoutArn: LayoutArn,
    layoutId: LayoutId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateLayoutResponse = {
    import CreateLayoutResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateLayoutResponse
      .builder()
      .layoutArn(LayoutArn.unwrap(layoutArn): java.lang.String)
      .layoutId(LayoutId.unwrap(layoutId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateLayoutResponse.ReadOnly =
    zio.aws.connectcases.model.CreateLayoutResponse.wrap(buildAwsValue())
}
object CreateLayoutResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateLayoutResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateLayoutResponse =
      zio.aws.connectcases.model.CreateLayoutResponse(layoutArn, layoutId)
    def layoutArn: LayoutArn
    def layoutId: LayoutId
    def getLayoutArn: ZIO[Any, Nothing, LayoutArn] = ZIO.succeed(layoutArn)
    def getLayoutId: ZIO[Any, Nothing, LayoutId] = ZIO.succeed(layoutId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateLayoutResponse
  ) extends zio.aws.connectcases.model.CreateLayoutResponse.ReadOnly {
    override val layoutArn: LayoutArn =
      zio.aws.connectcases.model.primitives.LayoutArn(impl.layoutArn())
    override val layoutId: LayoutId =
      zio.aws.connectcases.model.primitives.LayoutId(impl.layoutId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateLayoutResponse
  ): zio.aws.connectcases.model.CreateLayoutResponse.ReadOnly = new Wrapper(
    impl
  )
}
