package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{FieldId, FieldArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateFieldResponse(fieldArn: FieldArn, fieldId: FieldId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateFieldResponse = {
    import CreateFieldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateFieldResponse
      .builder()
      .fieldArn(FieldArn.unwrap(fieldArn): java.lang.String)
      .fieldId(FieldId.unwrap(fieldId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateFieldResponse.ReadOnly =
    zio.aws.connectcases.model.CreateFieldResponse.wrap(buildAwsValue())
}
object CreateFieldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateFieldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateFieldResponse =
      zio.aws.connectcases.model.CreateFieldResponse(fieldArn, fieldId)
    def fieldArn: FieldArn
    def fieldId: FieldId
    def getFieldArn: ZIO[Any, Nothing, FieldArn] = ZIO.succeed(fieldArn)
    def getFieldId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(fieldId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateFieldResponse
  ) extends zio.aws.connectcases.model.CreateFieldResponse.ReadOnly {
    override val fieldArn: FieldArn =
      zio.aws.connectcases.model.primitives.FieldArn(impl.fieldArn())
    override val fieldId: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.fieldId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateFieldResponse
  ): zio.aws.connectcases.model.CreateFieldResponse.ReadOnly = new Wrapper(impl)
}
