package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{
  FieldName,
  DomainId,
  FieldDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFieldRequest(
    description: Optional[FieldDescription] = Optional.Absent,
    domainId: DomainId,
    name: FieldName,
    `type`: zio.aws.connectcases.model.FieldType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateFieldRequest = {
    import CreateFieldRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateFieldRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          FieldDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .name(FieldName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateFieldRequest.ReadOnly =
    zio.aws.connectcases.model.CreateFieldRequest.wrap(buildAwsValue())
}
object CreateFieldRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateFieldRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateFieldRequest =
      zio.aws.connectcases.model.CreateFieldRequest(
        description.map(value => value),
        domainId,
        name,
        `type`
      )
    def description: Optional[FieldDescription]
    def domainId: DomainId
    def name: FieldName
    def `type`: zio.aws.connectcases.model.FieldType
    def getDescription: ZIO[Any, AwsError, FieldDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getName: ZIO[Any, Nothing, FieldName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.connectcases.model.FieldType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateFieldRequest
  ) extends zio.aws.connectcases.model.CreateFieldRequest.ReadOnly {
    override val description: Optional[FieldDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.connectcases.model.primitives.FieldDescription(value)
      )
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val name: FieldName =
      zio.aws.connectcases.model.primitives.FieldName(impl.name())
    override val `type`: zio.aws.connectcases.model.FieldType =
      zio.aws.connectcases.model.FieldType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateFieldRequest
  ): zio.aws.connectcases.model.CreateFieldRequest.ReadOnly = new Wrapper(impl)
}
