package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{DomainId, DomainArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDomainResponse(
    domainArn: DomainArn,
    domainId: DomainId,
    domainStatus: zio.aws.connectcases.model.DomainStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateDomainResponse = {
    import CreateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateDomainResponse
      .builder()
      .domainArn(DomainArn.unwrap(domainArn): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .domainStatus(domainStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateDomainResponse.ReadOnly =
    zio.aws.connectcases.model.CreateDomainResponse.wrap(buildAwsValue())
}
object CreateDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateDomainResponse =
      zio.aws.connectcases.model
        .CreateDomainResponse(domainArn, domainId, domainStatus)
    def domainArn: DomainArn
    def domainId: DomainId
    def domainStatus: zio.aws.connectcases.model.DomainStatus
    def getDomainArn: ZIO[Any, Nothing, DomainArn] = ZIO.succeed(domainArn)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getDomainStatus
        : ZIO[Any, Nothing, zio.aws.connectcases.model.DomainStatus] =
      ZIO.succeed(domainStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateDomainResponse
  ) extends zio.aws.connectcases.model.CreateDomainResponse.ReadOnly {
    override val domainArn: DomainArn =
      zio.aws.connectcases.model.primitives.DomainArn(impl.domainArn())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val domainStatus: zio.aws.connectcases.model.DomainStatus =
      zio.aws.connectcases.model.DomainStatus.wrap(impl.domainStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateDomainResponse
  ): zio.aws.connectcases.model.CreateDomainResponse.ReadOnly = new Wrapper(
    impl
  )
}
