package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDomainRequest(name: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateDomainRequest = {
    import CreateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateDomainRequest
      .builder()
      .name(DomainName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateDomainRequest.ReadOnly =
    zio.aws.connectcases.model.CreateDomainRequest.wrap(buildAwsValue())
}
object CreateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateDomainRequest =
      zio.aws.connectcases.model.CreateDomainRequest(name)
    def name: DomainName
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateDomainRequest
  ) extends zio.aws.connectcases.model.CreateDomainRequest.ReadOnly {
    override val name: DomainName =
      zio.aws.connectcases.model.primitives.DomainName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateDomainRequest
  ): zio.aws.connectcases.model.CreateDomainRequest.ReadOnly = new Wrapper(impl)
}
