package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{ContactArn, Channel}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ContactFilter(
    channel: Optional[Iterable[Channel]] = Optional.Absent,
    contactArn: Optional[ContactArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ContactFilter = {
    import ContactFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ContactFilter
      .builder()
      .optionallyWith(
        channel.map(value =>
          value.map { item =>
            Channel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.channel)
      .optionallyWith(
        contactArn.map(value => ContactArn.unwrap(value): java.lang.String)
      )(_.contactArn)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ContactFilter.ReadOnly =
    zio.aws.connectcases.model.ContactFilter.wrap(buildAwsValue())
}
object ContactFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ContactFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ContactFilter =
      zio.aws.connectcases.model.ContactFilter(
        channel.map(value => value),
        contactArn.map(value => value)
      )
    def channel: Optional[List[Channel]]
    def contactArn: Optional[ContactArn]
    def getChannel: ZIO[Any, AwsError, List[Channel]] =
      AwsError.unwrapOptionField("channel", channel)
    def getContactArn: ZIO[Any, AwsError, ContactArn] =
      AwsError.unwrapOptionField("contactArn", contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ContactFilter
  ) extends zio.aws.connectcases.model.ContactFilter.ReadOnly {
    override val channel: Optional[List[Channel]] = zio.aws.core.internal
      .optionalFromNullable(impl.channel())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connectcases.model.primitives.Channel(item)
        }.toList
      )
    override val contactArn: Optional[ContactArn] = zio.aws.core.internal
      .optionalFromNullable(impl.contactArn())
      .map(value => zio.aws.connectcases.model.primitives.ContactArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ContactFilter
  ): zio.aws.connectcases.model.ContactFilter.ReadOnly = new Wrapper(impl)
}
