package zio.aws.connectcases.model
import scala.jdk.CollectionConverters.*
sealed trait CommentBodyTextType {
  def unwrap
      : software.amazon.awssdk.services.connectcases.model.CommentBodyTextType
}
object CommentBodyTextType {
  def wrap(
      value: software.amazon.awssdk.services.connectcases.model.CommentBodyTextType
  ): zio.aws.connectcases.model.CommentBodyTextType = value match {
    case software.amazon.awssdk.services.connectcases.model.CommentBodyTextType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connectcases.model.CommentBodyTextType.TEXT_PLAIN =>
      val r = `Text/Plain`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connectcases.model.CommentBodyTextType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.CommentBodyTextType =
      software.amazon.awssdk.services.connectcases.model.CommentBodyTextType.UNKNOWN_TO_SDK_VERSION
  }
  case object `Text/Plain`
      extends zio.aws.connectcases.model.CommentBodyTextType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.CommentBodyTextType =
      software.amazon.awssdk.services.connectcases.model.CommentBodyTextType.TEXT_PLAIN
  }
}
