package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{LayoutName, LayoutId, DomainId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateLayoutRequest(
    content: Optional[zio.aws.connectcases.model.LayoutContent] =
      Optional.Absent,
    domainId: DomainId,
    layoutId: LayoutId,
    name: Optional[LayoutName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.UpdateLayoutRequest = {
    import UpdateLayoutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.UpdateLayoutRequest
      .builder()
      .optionallyWith(content.map(value => value.buildAwsValue()))(_.content)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .layoutId(LayoutId.unwrap(layoutId): java.lang.String)
      .optionallyWith(
        name.map(value => LayoutName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.UpdateLayoutRequest.ReadOnly =
    zio.aws.connectcases.model.UpdateLayoutRequest.wrap(buildAwsValue())
}
object UpdateLayoutRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.UpdateLayoutRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.UpdateLayoutRequest =
      zio.aws.connectcases.model.UpdateLayoutRequest(
        content.map(value => value.asEditable),
        domainId,
        layoutId,
        name.map(value => value)
      )
    def content: Optional[zio.aws.connectcases.model.LayoutContent.ReadOnly]
    def domainId: DomainId
    def layoutId: LayoutId
    def name: Optional[LayoutName]
    def getContent: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.LayoutContent.ReadOnly
    ] = AwsError.unwrapOptionField("content", content)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getLayoutId: ZIO[Any, Nothing, LayoutId] = ZIO.succeed(layoutId)
    def getName: ZIO[Any, AwsError, LayoutName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.UpdateLayoutRequest
  ) extends zio.aws.connectcases.model.UpdateLayoutRequest.ReadOnly {
    override val content
        : Optional[zio.aws.connectcases.model.LayoutContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value => zio.aws.connectcases.model.LayoutContent.wrap(value))
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val layoutId: LayoutId =
      zio.aws.connectcases.model.primitives.LayoutId(impl.layoutId())
    override val name: Optional[LayoutName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connectcases.model.primitives.LayoutName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.UpdateLayoutRequest
  ): zio.aws.connectcases.model.UpdateLayoutRequest.ReadOnly = new Wrapper(impl)
}
