package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{
  FieldName,
  FieldId,
  DomainId,
  FieldDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFieldRequest(
    description: Optional[FieldDescription] = Optional.Absent,
    domainId: DomainId,
    fieldId: FieldId,
    name: Optional[FieldName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.UpdateFieldRequest = {
    import UpdateFieldRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.UpdateFieldRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          FieldDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .fieldId(FieldId.unwrap(fieldId): java.lang.String)
      .optionallyWith(
        name.map(value => FieldName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.UpdateFieldRequest.ReadOnly =
    zio.aws.connectcases.model.UpdateFieldRequest.wrap(buildAwsValue())
}
object UpdateFieldRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.UpdateFieldRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.UpdateFieldRequest =
      zio.aws.connectcases.model.UpdateFieldRequest(
        description.map(value => value),
        domainId,
        fieldId,
        name.map(value => value)
      )
    def description: Optional[FieldDescription]
    def domainId: DomainId
    def fieldId: FieldId
    def name: Optional[FieldName]
    def getDescription: ZIO[Any, AwsError, FieldDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFieldId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(fieldId)
    def getName: ZIO[Any, AwsError, FieldName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.UpdateFieldRequest
  ) extends zio.aws.connectcases.model.UpdateFieldRequest.ReadOnly {
    override val description: Optional[FieldDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.connectcases.model.primitives.FieldDescription(value)
      )
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val fieldId: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.fieldId())
    override val name: Optional[FieldName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connectcases.model.primitives.FieldName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.UpdateFieldRequest
  ): zio.aws.connectcases.model.UpdateFieldRequest.ReadOnly = new Wrapper(impl)
}
