package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{TagKey, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(arn: Arn, tagKeys: Iterable[TagKey]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.UntagResourceRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.UntagResourceRequest.ReadOnly =
    zio.aws.connectcases.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.UntagResourceRequest =
      zio.aws.connectcases.model.UntagResourceRequest(arn, tagKeys)
    def arn: Arn
    def tagKeys: List[TagKey]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.UntagResourceRequest
  ) extends zio.aws.connectcases.model.UntagResourceRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.connectcases.model.primitives.Arn(impl.arn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.UntagResourceRequest
  ): zio.aws.connectcases.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
