package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{
  TemplateId,
  TemplateArn,
  TemplateName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TemplateSummary(
    name: TemplateName,
    status: zio.aws.connectcases.model.TemplateStatus,
    templateArn: TemplateArn,
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.TemplateSummary = {
    import TemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.TemplateSummary
      .builder()
      .name(TemplateName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .templateArn(TemplateArn.unwrap(templateArn): java.lang.String)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.TemplateSummary.ReadOnly =
    zio.aws.connectcases.model.TemplateSummary.wrap(buildAwsValue())
}
object TemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.TemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.TemplateSummary =
      zio.aws.connectcases.model.TemplateSummary(
        name,
        status,
        templateArn,
        templateId
      )
    def name: TemplateName
    def status: zio.aws.connectcases.model.TemplateStatus
    def templateArn: TemplateArn
    def templateId: TemplateId
    def getName: ZIO[Any, Nothing, TemplateName] = ZIO.succeed(name)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.connectcases.model.TemplateStatus] =
      ZIO.succeed(status)
    def getTemplateArn: ZIO[Any, Nothing, TemplateArn] =
      ZIO.succeed(templateArn)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.TemplateSummary
  ) extends zio.aws.connectcases.model.TemplateSummary.ReadOnly {
    override val name: TemplateName =
      zio.aws.connectcases.model.primitives.TemplateName(impl.name())
    override val status: zio.aws.connectcases.model.TemplateStatus =
      zio.aws.connectcases.model.TemplateStatus.wrap(impl.status())
    override val templateArn: TemplateArn =
      zio.aws.connectcases.model.primitives.TemplateArn(impl.templateArn())
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.TemplateSummary
  ): zio.aws.connectcases.model.TemplateSummary.ReadOnly = new Wrapper(impl)
}
