package zio.aws.connectcases.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcases.model.primitives.{RelatedItemId, AssociationTime}
import scala.jdk.CollectionConverters.*
final case class SearchRelatedItemsResponseItem(
    associationTime: AssociationTime,
    content: zio.aws.connectcases.model.RelatedItemContent,
    relatedItemId: RelatedItemId,
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: zio.aws.connectcases.model.RelatedItemType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseItem = {
    import SearchRelatedItemsResponseItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseItem
      .builder()
      .associationTime(AssociationTime.unwrap(associationTime): Instant)
      .content(content.buildAwsValue())
      .relatedItemId(RelatedItemId.unwrap(relatedItemId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly =
    zio.aws.connectcases.model.SearchRelatedItemsResponseItem
      .wrap(buildAwsValue())
}
object SearchRelatedItemsResponseItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.SearchRelatedItemsResponseItem =
      zio.aws.connectcases.model.SearchRelatedItemsResponseItem(
        associationTime,
        content.asEditable,
        relatedItemId,
        tags.map(value => value),
        `type`
      )
    def associationTime: AssociationTime
    def content: zio.aws.connectcases.model.RelatedItemContent.ReadOnly
    def relatedItemId: RelatedItemId
    def tags: Optional[Map[String, String]]
    def `type`: zio.aws.connectcases.model.RelatedItemType
    def getAssociationTime: ZIO[Any, Nothing, AssociationTime] =
      ZIO.succeed(associationTime)
    def getContent: ZIO[
      Any,
      Nothing,
      zio.aws.connectcases.model.RelatedItemContent.ReadOnly
    ] = ZIO.succeed(content)
    def getRelatedItemId: ZIO[Any, Nothing, RelatedItemId] =
      ZIO.succeed(relatedItemId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.connectcases.model.RelatedItemType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseItem
  ) extends zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly {
    override val associationTime: AssociationTime =
      zio.aws.connectcases.model.primitives
        .AssociationTime(impl.associationTime())
    override val content
        : zio.aws.connectcases.model.RelatedItemContent.ReadOnly =
      zio.aws.connectcases.model.RelatedItemContent.wrap(impl.content())
    override val relatedItemId: RelatedItemId =
      zio.aws.connectcases.model.primitives.RelatedItemId(impl.relatedItemId())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: zio.aws.connectcases.model.RelatedItemType =
      zio.aws.connectcases.model.RelatedItemType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseItem
  ): zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly =
    new Wrapper(impl)
}
