package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchRelatedItemsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    relatedItems: Iterable[
      zio.aws.connectcases.model.SearchRelatedItemsResponseItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse = {
    import SearchRelatedItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .relatedItems(relatedItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.SearchRelatedItemsResponse.ReadOnly =
    zio.aws.connectcases.model.SearchRelatedItemsResponse.wrap(buildAwsValue())
}
object SearchRelatedItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.SearchRelatedItemsResponse =
      zio.aws.connectcases.model.SearchRelatedItemsResponse(
        nextToken.map(value => value),
        relatedItems.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def relatedItems: List[
      zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRelatedItems: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly
    ]] = ZIO.succeed(relatedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse
  ) extends zio.aws.connectcases.model.SearchRelatedItemsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
    override val relatedItems: List[
      zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly
    ] = impl
      .relatedItems()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.SearchRelatedItemsResponseItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse
  ): zio.aws.connectcases.model.SearchRelatedItemsResponse.ReadOnly =
    new Wrapper(impl)
}
