package zio.aws.connectcases.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcases.model.primitives.{
  NextToken,
  SearchRelatedItemsRequestMaxResultsInteger,
  DomainId,
  CaseId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchRelatedItemsRequest(
    caseId: CaseId,
    domainId: DomainId,
    filters: Optional[
      Iterable[zio.aws.connectcases.model.RelatedItemTypeFilter]
    ] = Optional.Absent,
    maxResults: Optional[SearchRelatedItemsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest = {
    import SearchRelatedItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest
      .builder()
      .caseId(CaseId.unwrap(caseId): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          SearchRelatedItemsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.SearchRelatedItemsRequest.ReadOnly =
    zio.aws.connectcases.model.SearchRelatedItemsRequest.wrap(buildAwsValue())
}
object SearchRelatedItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.SearchRelatedItemsRequest =
      zio.aws.connectcases.model.SearchRelatedItemsRequest(
        caseId,
        domainId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def caseId: CaseId
    def domainId: DomainId
    def filters: Optional[
      List[zio.aws.connectcases.model.RelatedItemTypeFilter.ReadOnly]
    ]
    def maxResults: Optional[SearchRelatedItemsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getCaseId: ZIO[Any, Nothing, CaseId] = ZIO.succeed(caseId)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.connectcases.model.RelatedItemTypeFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, SearchRelatedItemsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest
  ) extends zio.aws.connectcases.model.SearchRelatedItemsRequest.ReadOnly {
    override val caseId: CaseId =
      zio.aws.connectcases.model.primitives.CaseId(impl.caseId())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val filters: Optional[
      List[zio.aws.connectcases.model.RelatedItemTypeFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connectcases.model.RelatedItemTypeFilter.wrap(item)
        }.toList
      )
    override val maxResults
        : Optional[SearchRelatedItemsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.connectcases.model.primitives
            .SearchRelatedItemsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest
  ): zio.aws.connectcases.model.SearchRelatedItemsRequest.ReadOnly =
    new Wrapper(impl)
}
