package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RelatedItemTypeFilter(
    comment: Optional[zio.aws.connectcases.model.CommentFilter] =
      Optional.Absent,
    contact: Optional[zio.aws.connectcases.model.ContactFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter = {
    import RelatedItemTypeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .optionallyWith(contact.map(value => value.buildAwsValue()))(_.contact)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.RelatedItemTypeFilter.ReadOnly =
    zio.aws.connectcases.model.RelatedItemTypeFilter.wrap(buildAwsValue())
}
object RelatedItemTypeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.RelatedItemTypeFilter =
      zio.aws.connectcases.model.RelatedItemTypeFilter(
        comment.map(value => value.asEditable),
        contact.map(value => value.asEditable)
      )
    def comment: Optional[zio.aws.connectcases.model.CommentFilter.ReadOnly]
    def contact: Optional[zio.aws.connectcases.model.ContactFilter.ReadOnly]
    def getComment: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.CommentFilter.ReadOnly
    ] = AwsError.unwrapOptionField("comment", comment)
    def getContact: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.ContactFilter.ReadOnly
    ] = AwsError.unwrapOptionField("contact", contact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter
  ) extends zio.aws.connectcases.model.RelatedItemTypeFilter.ReadOnly {
    override val comment
        : Optional[zio.aws.connectcases.model.CommentFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.connectcases.model.CommentFilter.wrap(value))
    override val contact
        : Optional[zio.aws.connectcases.model.ContactFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contact())
        .map(value => zio.aws.connectcases.model.ContactFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.RelatedItemTypeFilter
  ): zio.aws.connectcases.model.RelatedItemTypeFilter.ReadOnly = new Wrapper(
    impl
  )
}
