package zio.aws.connectcases.model
import scala.jdk.CollectionConverters.*
sealed trait RelatedItemType {
  def unwrap: software.amazon.awssdk.services.connectcases.model.RelatedItemType
}
object RelatedItemType {
  def wrap(
      value: software.amazon.awssdk.services.connectcases.model.RelatedItemType
  ): zio.aws.connectcases.model.RelatedItemType = value match {
    case software.amazon.awssdk.services.connectcases.model.RelatedItemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connectcases.model.RelatedItemType.CONTACT =>
      val r = Contact
      r
    case software.amazon.awssdk.services.connectcases.model.RelatedItemType.COMMENT =>
      val r = Comment
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connectcases.model.RelatedItemType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.RelatedItemType =
      software.amazon.awssdk.services.connectcases.model.RelatedItemType.UNKNOWN_TO_SDK_VERSION
  }
  case object Contact extends zio.aws.connectcases.model.RelatedItemType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.RelatedItemType =
      software.amazon.awssdk.services.connectcases.model.RelatedItemType.CONTACT
  }
  case object Comment extends zio.aws.connectcases.model.RelatedItemType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.RelatedItemType =
      software.amazon.awssdk.services.connectcases.model.RelatedItemType.COMMENT
  }
}
