package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RelatedItemInputContent(
    comment: Optional[zio.aws.connectcases.model.CommentContent] =
      Optional.Absent,
    contact: Optional[zio.aws.connectcases.model.Contact] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.RelatedItemInputContent = {
    import RelatedItemInputContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.RelatedItemInputContent
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .optionallyWith(contact.map(value => value.buildAwsValue()))(_.contact)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.RelatedItemInputContent.ReadOnly =
    zio.aws.connectcases.model.RelatedItemInputContent.wrap(buildAwsValue())
}
object RelatedItemInputContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.RelatedItemInputContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.RelatedItemInputContent =
      zio.aws.connectcases.model.RelatedItemInputContent(
        comment.map(value => value.asEditable),
        contact.map(value => value.asEditable)
      )
    def comment: Optional[zio.aws.connectcases.model.CommentContent.ReadOnly]
    def contact: Optional[zio.aws.connectcases.model.Contact.ReadOnly]
    def getComment: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.CommentContent.ReadOnly
    ] = AwsError.unwrapOptionField("comment", comment)
    def getContact
        : ZIO[Any, AwsError, zio.aws.connectcases.model.Contact.ReadOnly] =
      AwsError.unwrapOptionField("contact", contact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.RelatedItemInputContent
  ) extends zio.aws.connectcases.model.RelatedItemInputContent.ReadOnly {
    override val comment
        : Optional[zio.aws.connectcases.model.CommentContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.connectcases.model.CommentContent.wrap(value))
    override val contact
        : Optional[zio.aws.connectcases.model.Contact.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contact())
        .map(value => zio.aws.connectcases.model.Contact.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.RelatedItemInputContent
  ): zio.aws.connectcases.model.RelatedItemInputContent.ReadOnly = new Wrapper(
    impl
  )
}
