package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListTagsForResourceRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.connectcases.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListTagsForResourceRequest =
      zio.aws.connectcases.model.ListTagsForResourceRequest(arn)
    def arn: Arn
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListTagsForResourceRequest
  ) extends zio.aws.connectcases.model.ListTagsForResourceRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.connectcases.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListTagsForResourceRequest
  ): zio.aws.connectcases.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
