package zio.aws.connectcases.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcases.model.primitives.{
  NextToken,
  ListCasesForContactRequestMaxResultsInteger,
  DomainId,
  ContactArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCasesForContactRequest(
    contactArn: ContactArn,
    domainId: DomainId,
    maxResults: Optional[ListCasesForContactRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest = {
    import ListCasesForContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest
      .builder()
      .contactArn(ContactArn.unwrap(contactArn): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListCasesForContactRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.ListCasesForContactRequest.ReadOnly =
    zio.aws.connectcases.model.ListCasesForContactRequest.wrap(buildAwsValue())
}
object ListCasesForContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListCasesForContactRequest =
      zio.aws.connectcases.model.ListCasesForContactRequest(
        contactArn,
        domainId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def contactArn: ContactArn
    def domainId: DomainId
    def maxResults: Optional[ListCasesForContactRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getContactArn: ZIO[Any, Nothing, ContactArn] = ZIO.succeed(contactArn)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getMaxResults
        : ZIO[Any, AwsError, ListCasesForContactRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest
  ) extends zio.aws.connectcases.model.ListCasesForContactRequest.ReadOnly {
    override val contactArn: ContactArn =
      zio.aws.connectcases.model.primitives.ContactArn(impl.contactArn())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val maxResults
        : Optional[ListCasesForContactRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.connectcases.model.primitives
            .ListCasesForContactRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest
  ): zio.aws.connectcases.model.ListCasesForContactRequest.ReadOnly =
    new Wrapper(impl)
}
