package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LayoutSections(
    sections: Optional[Iterable[zio.aws.connectcases.model.Section]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.LayoutSections = {
    import LayoutSections.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.LayoutSections
      .builder()
      .optionallyWith(
        sections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sections)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.LayoutSections.ReadOnly =
    zio.aws.connectcases.model.LayoutSections.wrap(buildAwsValue())
}
object LayoutSections {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.LayoutSections
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.LayoutSections =
      zio.aws.connectcases.model.LayoutSections(
        sections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sections: Optional[List[zio.aws.connectcases.model.Section.ReadOnly]]
    def getSections: ZIO[Any, AwsError, List[
      zio.aws.connectcases.model.Section.ReadOnly
    ]] = AwsError.unwrapOptionField("sections", sections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.LayoutSections
  ) extends zio.aws.connectcases.model.LayoutSections.ReadOnly {
    override val sections
        : Optional[List[zio.aws.connectcases.model.Section.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.Section.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.LayoutSections
  ): zio.aws.connectcases.model.LayoutSections.ReadOnly = new Wrapper(impl)
}
