package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{
  TemplateId,
  TemplateArn,
  TemplateName,
  TemplateDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetTemplateResponse(
    description: Optional[TemplateDescription] = Optional.Absent,
    layoutConfiguration: Optional[
      zio.aws.connectcases.model.LayoutConfiguration
    ] = Optional.Absent,
    name: TemplateName,
    requiredFields: Optional[
      Iterable[zio.aws.connectcases.model.RequiredField]
    ] = Optional.Absent,
    status: zio.aws.connectcases.model.TemplateStatus,
    tags: Optional[Map[String, String]] = Optional.Absent,
    templateArn: TemplateArn,
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetTemplateResponse = {
    import GetTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetTemplateResponse
      .builder()
      .optionallyWith(
        description.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(layoutConfiguration.map(value => value.buildAwsValue()))(
        _.layoutConfiguration
      )
      .name(TemplateName.unwrap(name): java.lang.String)
      .optionallyWith(
        requiredFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requiredFields)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .templateArn(TemplateArn.unwrap(templateArn): java.lang.String)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetTemplateResponse.ReadOnly =
    zio.aws.connectcases.model.GetTemplateResponse.wrap(buildAwsValue())
}
object GetTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetTemplateResponse =
      zio.aws.connectcases.model.GetTemplateResponse(
        description.map(value => value),
        layoutConfiguration.map(value => value.asEditable),
        name,
        requiredFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status,
        tags.map(value => value),
        templateArn,
        templateId
      )
    def description: Optional[TemplateDescription]
    def layoutConfiguration
        : Optional[zio.aws.connectcases.model.LayoutConfiguration.ReadOnly]
    def name: TemplateName
    def requiredFields
        : Optional[List[zio.aws.connectcases.model.RequiredField.ReadOnly]]
    def status: zio.aws.connectcases.model.TemplateStatus
    def tags: Optional[Map[String, String]]
    def templateArn: TemplateArn
    def templateId: TemplateId
    def getDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLayoutConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.LayoutConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("layoutConfiguration", layoutConfiguration)
    def getName: ZIO[Any, Nothing, TemplateName] = ZIO.succeed(name)
    def getRequiredFields: ZIO[Any, AwsError, List[
      zio.aws.connectcases.model.RequiredField.ReadOnly
    ]] = AwsError.unwrapOptionField("requiredFields", requiredFields)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.connectcases.model.TemplateStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateArn: ZIO[Any, Nothing, TemplateArn] =
      ZIO.succeed(templateArn)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetTemplateResponse
  ) extends zio.aws.connectcases.model.GetTemplateResponse.ReadOnly {
    override val description: Optional[TemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connectcases.model.primitives.TemplateDescription(value)
        )
    override val layoutConfiguration
        : Optional[zio.aws.connectcases.model.LayoutConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layoutConfiguration())
        .map(value =>
          zio.aws.connectcases.model.LayoutConfiguration.wrap(value)
        )
    override val name: TemplateName =
      zio.aws.connectcases.model.primitives.TemplateName(impl.name())
    override val requiredFields
        : Optional[List[zio.aws.connectcases.model.RequiredField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.RequiredField.wrap(item)
          }.toList
        )
    override val status: zio.aws.connectcases.model.TemplateStatus =
      zio.aws.connectcases.model.TemplateStatus.wrap(impl.status())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val templateArn: TemplateArn =
      zio.aws.connectcases.model.primitives.TemplateArn(impl.templateArn())
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetTemplateResponse
  ): zio.aws.connectcases.model.GetTemplateResponse.ReadOnly = new Wrapper(impl)
}
