package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{TemplateId, DomainId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTemplateRequest(
    domainId: DomainId,
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetTemplateRequest = {
    import GetTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetTemplateRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetTemplateRequest.ReadOnly =
    zio.aws.connectcases.model.GetTemplateRequest.wrap(buildAwsValue())
}
object GetTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetTemplateRequest =
      zio.aws.connectcases.model.GetTemplateRequest(domainId, templateId)
    def domainId: DomainId
    def templateId: TemplateId
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetTemplateRequest
  ) extends zio.aws.connectcases.model.GetTemplateRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetTemplateRequest
  ): zio.aws.connectcases.model.GetTemplateRequest.ReadOnly = new Wrapper(impl)
}
