package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.FieldOptionValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FieldOptionError(
    errorCode: String,
    message: String,
    value: FieldOptionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldOptionError = {
    import FieldOptionError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldOptionError
      .builder()
      .errorCode(errorCode: java.lang.String)
      .message(message: java.lang.String)
      .value(FieldOptionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldOptionError.ReadOnly =
    zio.aws.connectcases.model.FieldOptionError.wrap(buildAwsValue())
}
object FieldOptionError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldOptionError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldOptionError =
      zio.aws.connectcases.model.FieldOptionError(errorCode, message, value)
    def errorCode: String
    def message: String
    def value: FieldOptionValue
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
    def getValue: ZIO[Any, Nothing, FieldOptionValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldOptionError
  ) extends zio.aws.connectcases.model.FieldOptionError.ReadOnly {
    override val errorCode: String = impl.errorCode(): String
    override val message: String = impl.message(): String
    override val value: FieldOptionValue =
      zio.aws.connectcases.model.primitives.FieldOptionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldOptionError
  ): zio.aws.connectcases.model.FieldOptionError.ReadOnly = new Wrapper(impl)
}
