package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FieldFilter(
    contains: Optional[zio.aws.connectcases.model.FieldValue] = Optional.Absent,
    equalTo: Optional[zio.aws.connectcases.model.FieldValue] = Optional.Absent,
    greaterThan: Optional[zio.aws.connectcases.model.FieldValue] =
      Optional.Absent,
    greaterThanOrEqualTo: Optional[zio.aws.connectcases.model.FieldValue] =
      Optional.Absent,
    lessThan: Optional[zio.aws.connectcases.model.FieldValue] = Optional.Absent,
    lessThanOrEqualTo: Optional[zio.aws.connectcases.model.FieldValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldFilter = {
    import FieldFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldFilter
      .builder()
      .optionallyWith(contains.map(value => value.buildAwsValue()))(_.contains)
      .optionallyWith(equalTo.map(value => value.buildAwsValue()))(_.equalTo)
      .optionallyWith(greaterThan.map(value => value.buildAwsValue()))(
        _.greaterThan
      )
      .optionallyWith(greaterThanOrEqualTo.map(value => value.buildAwsValue()))(
        _.greaterThanOrEqualTo
      )
      .optionallyWith(lessThan.map(value => value.buildAwsValue()))(_.lessThan)
      .optionallyWith(lessThanOrEqualTo.map(value => value.buildAwsValue()))(
        _.lessThanOrEqualTo
      )
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldFilter.ReadOnly =
    zio.aws.connectcases.model.FieldFilter.wrap(buildAwsValue())
}
object FieldFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldFilter =
      zio.aws.connectcases.model.FieldFilter(
        contains.map(value => value.asEditable),
        equalTo.map(value => value.asEditable),
        greaterThan.map(value => value.asEditable),
        greaterThanOrEqualTo.map(value => value.asEditable),
        lessThan.map(value => value.asEditable),
        lessThanOrEqualTo.map(value => value.asEditable)
      )
    def contains: Optional[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def equalTo: Optional[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def greaterThan: Optional[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def greaterThanOrEqualTo
        : Optional[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def lessThan: Optional[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def lessThanOrEqualTo
        : Optional[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def getContains
        : ZIO[Any, AwsError, zio.aws.connectcases.model.FieldValue.ReadOnly] =
      AwsError.unwrapOptionField("contains", contains)
    def getEqualTo
        : ZIO[Any, AwsError, zio.aws.connectcases.model.FieldValue.ReadOnly] =
      AwsError.unwrapOptionField("equalTo", equalTo)
    def getGreaterThan
        : ZIO[Any, AwsError, zio.aws.connectcases.model.FieldValue.ReadOnly] =
      AwsError.unwrapOptionField("greaterThan", greaterThan)
    def getGreaterThanOrEqualTo
        : ZIO[Any, AwsError, zio.aws.connectcases.model.FieldValue.ReadOnly] =
      AwsError.unwrapOptionField("greaterThanOrEqualTo", greaterThanOrEqualTo)
    def getLessThan
        : ZIO[Any, AwsError, zio.aws.connectcases.model.FieldValue.ReadOnly] =
      AwsError.unwrapOptionField("lessThan", lessThan)
    def getLessThanOrEqualTo
        : ZIO[Any, AwsError, zio.aws.connectcases.model.FieldValue.ReadOnly] =
      AwsError.unwrapOptionField("lessThanOrEqualTo", lessThanOrEqualTo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldFilter
  ) extends zio.aws.connectcases.model.FieldFilter.ReadOnly {
    override val contains
        : Optional[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contains())
        .map(value => zio.aws.connectcases.model.FieldValue.wrap(value))
    override val equalTo
        : Optional[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.equalTo())
        .map(value => zio.aws.connectcases.model.FieldValue.wrap(value))
    override val greaterThan
        : Optional[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greaterThan())
        .map(value => zio.aws.connectcases.model.FieldValue.wrap(value))
    override val greaterThanOrEqualTo
        : Optional[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greaterThanOrEqualTo())
        .map(value => zio.aws.connectcases.model.FieldValue.wrap(value))
    override val lessThan
        : Optional[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lessThan())
        .map(value => zio.aws.connectcases.model.FieldValue.wrap(value))
    override val lessThanOrEqualTo
        : Optional[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lessThanOrEqualTo())
        .map(value => zio.aws.connectcases.model.FieldValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldFilter
  ): zio.aws.connectcases.model.FieldFilter.ReadOnly = new Wrapper(impl)
}
