package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventBridgeConfiguration(
    enabled: Boolean,
    includedData: Optional[zio.aws.connectcases.model.EventIncludedData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.EventBridgeConfiguration = {
    import EventBridgeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.EventBridgeConfiguration
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(includedData.map(value => value.buildAwsValue()))(
        _.includedData
      )
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.EventBridgeConfiguration.ReadOnly =
    zio.aws.connectcases.model.EventBridgeConfiguration.wrap(buildAwsValue())
}
object EventBridgeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.EventBridgeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.EventBridgeConfiguration =
      zio.aws.connectcases.model.EventBridgeConfiguration(
        enabled,
        includedData.map(value => value.asEditable)
      )
    def enabled: Boolean
    def includedData
        : Optional[zio.aws.connectcases.model.EventIncludedData.ReadOnly]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getIncludedData: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.EventIncludedData.ReadOnly
    ] = AwsError.unwrapOptionField("includedData", includedData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.EventBridgeConfiguration
  ) extends zio.aws.connectcases.model.EventBridgeConfiguration.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val includedData
        : Optional[zio.aws.connectcases.model.EventIncludedData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includedData())
        .map(value => zio.aws.connectcases.model.EventIncludedData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.EventBridgeConfiguration
  ): zio.aws.connectcases.model.EventBridgeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
