package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{DomainName, DomainId, DomainArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DomainSummary(
    domainArn: DomainArn,
    domainId: DomainId,
    name: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.DomainSummary = {
    import DomainSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.DomainSummary
      .builder()
      .domainArn(DomainArn.unwrap(domainArn): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .name(DomainName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.DomainSummary.ReadOnly =
    zio.aws.connectcases.model.DomainSummary.wrap(buildAwsValue())
}
object DomainSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.DomainSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.DomainSummary =
      zio.aws.connectcases.model.DomainSummary(domainArn, domainId, name)
    def domainArn: DomainArn
    def domainId: DomainId
    def name: DomainName
    def getDomainArn: ZIO[Any, Nothing, DomainArn] = ZIO.succeed(domainArn)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.DomainSummary
  ) extends zio.aws.connectcases.model.DomainSummary.ReadOnly {
    override val domainArn: DomainArn =
      zio.aws.connectcases.model.primitives.DomainArn(impl.domainArn())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val name: DomainName =
      zio.aws.connectcases.model.primitives.DomainName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.DomainSummary
  ): zio.aws.connectcases.model.DomainSummary.ReadOnly = new Wrapper(impl)
}
