package zio.aws.connectcases.model
import scala.jdk.CollectionConverters.*
sealed trait DomainStatus {
  def unwrap: software.amazon.awssdk.services.connectcases.model.DomainStatus
}
object DomainStatus {
  def wrap(
      value: software.amazon.awssdk.services.connectcases.model.DomainStatus
  ): zio.aws.connectcases.model.DomainStatus = value match {
    case software.amazon.awssdk.services.connectcases.model.DomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connectcases.model.DomainStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.connectcases.model.DomainStatus.CREATION_IN_PROGRESS =>
      val r = CreationInProgress
      r
    case software.amazon.awssdk.services.connectcases.model.DomainStatus.CREATION_FAILED =>
      val r = CreationFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connectcases.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.DomainStatus =
      software.amazon.awssdk.services.connectcases.model.DomainStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.connectcases.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.DomainStatus =
      software.amazon.awssdk.services.connectcases.model.DomainStatus.ACTIVE
  }
  case object CreationInProgress
      extends zio.aws.connectcases.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.DomainStatus =
      software.amazon.awssdk.services.connectcases.model.DomainStatus.CREATION_IN_PROGRESS
  }
  case object CreationFailed extends zio.aws.connectcases.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.DomainStatus =
      software.amazon.awssdk.services.connectcases.model.DomainStatus.CREATION_FAILED
  }
}
