package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.DomainId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDomainRequest(domainId: DomainId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.DeleteDomainRequest = {
    import DeleteDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.DeleteDomainRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.DeleteDomainRequest.ReadOnly =
    zio.aws.connectcases.model.DeleteDomainRequest.wrap(buildAwsValue())
}
object DeleteDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.DeleteDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.DeleteDomainRequest =
      zio.aws.connectcases.model.DeleteDomainRequest(domainId)
    def domainId: DomainId
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.DeleteDomainRequest
  ) extends zio.aws.connectcases.model.DeleteDomainRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.DeleteDomainRequest
  ): zio.aws.connectcases.model.DeleteDomainRequest.ReadOnly = new Wrapper(impl)
}
