package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{TemplateId, TemplateArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateTemplateResponse(
    templateArn: TemplateArn,
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateTemplateResponse = {
    import CreateTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateTemplateResponse
      .builder()
      .templateArn(TemplateArn.unwrap(templateArn): java.lang.String)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateTemplateResponse.ReadOnly =
    zio.aws.connectcases.model.CreateTemplateResponse.wrap(buildAwsValue())
}
object CreateTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateTemplateResponse =
      zio.aws.connectcases.model.CreateTemplateResponse(templateArn, templateId)
    def templateArn: TemplateArn
    def templateId: TemplateId
    def getTemplateArn: ZIO[Any, Nothing, TemplateArn] =
      ZIO.succeed(templateArn)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateTemplateResponse
  ) extends zio.aws.connectcases.model.CreateTemplateResponse.ReadOnly {
    override val templateArn: TemplateArn =
      zio.aws.connectcases.model.primitives.TemplateArn(impl.templateArn())
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateTemplateResponse
  ): zio.aws.connectcases.model.CreateTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
