package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{RelatedItemId, RelatedItemArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateRelatedItemResponse(
    relatedItemArn: RelatedItemArn,
    relatedItemId: RelatedItemId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateRelatedItemResponse = {
    import CreateRelatedItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateRelatedItemResponse
      .builder()
      .relatedItemArn(RelatedItemArn.unwrap(relatedItemArn): java.lang.String)
      .relatedItemId(RelatedItemId.unwrap(relatedItemId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.CreateRelatedItemResponse.ReadOnly =
    zio.aws.connectcases.model.CreateRelatedItemResponse.wrap(buildAwsValue())
}
object CreateRelatedItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateRelatedItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateRelatedItemResponse =
      zio.aws.connectcases.model
        .CreateRelatedItemResponse(relatedItemArn, relatedItemId)
    def relatedItemArn: RelatedItemArn
    def relatedItemId: RelatedItemId
    def getRelatedItemArn: ZIO[Any, Nothing, RelatedItemArn] =
      ZIO.succeed(relatedItemArn)
    def getRelatedItemId: ZIO[Any, Nothing, RelatedItemId] =
      ZIO.succeed(relatedItemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateRelatedItemResponse
  ) extends zio.aws.connectcases.model.CreateRelatedItemResponse.ReadOnly {
    override val relatedItemArn: RelatedItemArn =
      zio.aws.connectcases.model.primitives
        .RelatedItemArn(impl.relatedItemArn())
    override val relatedItemId: RelatedItemId =
      zio.aws.connectcases.model.primitives.RelatedItemId(impl.relatedItemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateRelatedItemResponse
  ): zio.aws.connectcases.model.CreateRelatedItemResponse.ReadOnly =
    new Wrapper(impl)
}
