package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{DomainId, CaseId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateRelatedItemRequest(
    caseId: CaseId,
    content: zio.aws.connectcases.model.RelatedItemInputContent,
    domainId: DomainId,
    `type`: zio.aws.connectcases.model.RelatedItemType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateRelatedItemRequest = {
    import CreateRelatedItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateRelatedItemRequest
      .builder()
      .caseId(CaseId.unwrap(caseId): java.lang.String)
      .content(content.buildAwsValue())
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateRelatedItemRequest.ReadOnly =
    zio.aws.connectcases.model.CreateRelatedItemRequest.wrap(buildAwsValue())
}
object CreateRelatedItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateRelatedItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateRelatedItemRequest =
      zio.aws.connectcases.model.CreateRelatedItemRequest(
        caseId,
        content.asEditable,
        domainId,
        `type`
      )
    def caseId: CaseId
    def content: zio.aws.connectcases.model.RelatedItemInputContent.ReadOnly
    def domainId: DomainId
    def `type`: zio.aws.connectcases.model.RelatedItemType
    def getCaseId: ZIO[Any, Nothing, CaseId] = ZIO.succeed(caseId)
    def getContent: ZIO[
      Any,
      Nothing,
      zio.aws.connectcases.model.RelatedItemInputContent.ReadOnly
    ] = ZIO.succeed(content)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getType: ZIO[Any, Nothing, zio.aws.connectcases.model.RelatedItemType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateRelatedItemRequest
  ) extends zio.aws.connectcases.model.CreateRelatedItemRequest.ReadOnly {
    override val caseId: CaseId =
      zio.aws.connectcases.model.primitives.CaseId(impl.caseId())
    override val content
        : zio.aws.connectcases.model.RelatedItemInputContent.ReadOnly =
      zio.aws.connectcases.model.RelatedItemInputContent.wrap(impl.content())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val `type`: zio.aws.connectcases.model.RelatedItemType =
      zio.aws.connectcases.model.RelatedItemType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateRelatedItemRequest
  ): zio.aws.connectcases.model.CreateRelatedItemRequest.ReadOnly = new Wrapper(
    impl
  )
}
