package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.ContactArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Contact(contactArn: ContactArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.Contact = {
    import Contact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.Contact
      .builder()
      .contactArn(ContactArn.unwrap(contactArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.Contact.ReadOnly =
    zio.aws.connectcases.model.Contact.wrap(buildAwsValue())
}
object Contact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.Contact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.Contact =
      zio.aws.connectcases.model.Contact(contactArn)
    def contactArn: ContactArn
    def getContactArn: ZIO[Any, Nothing, ContactArn] = ZIO.succeed(contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.Contact
  ) extends zio.aws.connectcases.model.Contact.ReadOnly {
    override val contactArn: ContactArn =
      zio.aws.connectcases.model.primitives.ContactArn(impl.contactArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.Contact
  ): zio.aws.connectcases.model.Contact.ReadOnly = new Wrapper(impl)
}
