package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.CommentBody
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CommentContent(
    body: CommentBody,
    contentType: zio.aws.connectcases.model.CommentBodyTextType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CommentContent = {
    import CommentContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CommentContent
      .builder()
      .body(CommentBody.unwrap(body): java.lang.String)
      .contentType(contentType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CommentContent.ReadOnly =
    zio.aws.connectcases.model.CommentContent.wrap(buildAwsValue())
}
object CommentContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CommentContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CommentContent =
      zio.aws.connectcases.model.CommentContent(body, contentType)
    def body: CommentBody
    def contentType: zio.aws.connectcases.model.CommentBodyTextType
    def getBody: ZIO[Any, Nothing, CommentBody] = ZIO.succeed(body)
    def getContentType
        : ZIO[Any, Nothing, zio.aws.connectcases.model.CommentBodyTextType] =
      ZIO.succeed(contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CommentContent
  ) extends zio.aws.connectcases.model.CommentContent.ReadOnly {
    override val body: CommentBody =
      zio.aws.connectcases.model.primitives.CommentBody(impl.body())
    override val contentType: zio.aws.connectcases.model.CommentBodyTextType =
      zio.aws.connectcases.model.CommentBodyTextType.wrap(impl.contentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CommentContent
  ): zio.aws.connectcases.model.CommentContent.ReadOnly = new Wrapper(impl)
}
