package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{FieldId, DomainId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchPutFieldOptionsRequest(
    domainId: DomainId,
    fieldId: FieldId,
    options: Iterable[zio.aws.connectcases.model.FieldOption]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsRequest = {
    import BatchPutFieldOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .fieldId(FieldId.unwrap(fieldId): java.lang.String)
      .options(options.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.BatchPutFieldOptionsRequest.ReadOnly =
    zio.aws.connectcases.model.BatchPutFieldOptionsRequest.wrap(buildAwsValue())
}
object BatchPutFieldOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.BatchPutFieldOptionsRequest =
      zio.aws.connectcases.model.BatchPutFieldOptionsRequest(
        domainId,
        fieldId,
        options.map { item =>
          item.asEditable
        }
      )
    def domainId: DomainId
    def fieldId: FieldId
    def options: List[zio.aws.connectcases.model.FieldOption.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFieldId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(fieldId)
    def getOptions: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldOption.ReadOnly
    ]] = ZIO.succeed(options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsRequest
  ) extends zio.aws.connectcases.model.BatchPutFieldOptionsRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val fieldId: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.fieldId())
    override val options
        : List[zio.aws.connectcases.model.FieldOption.ReadOnly] = impl
      .options()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.FieldOption.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsRequest
  ): zio.aws.connectcases.model.BatchPutFieldOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
