package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetFieldResponse(
    errors: Iterable[zio.aws.connectcases.model.FieldError],
    fields: Iterable[zio.aws.connectcases.model.GetFieldResponse]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.BatchGetFieldResponse = {
    import BatchGetFieldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.BatchGetFieldResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.BatchGetFieldResponse.ReadOnly =
    zio.aws.connectcases.model.BatchGetFieldResponse.wrap(buildAwsValue())
}
object BatchGetFieldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.BatchGetFieldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.BatchGetFieldResponse =
      zio.aws.connectcases.model.BatchGetFieldResponse(
        errors.map { item =>
          item.asEditable
        },
        fields.map { item =>
          item.asEditable
        }
      )
    def errors: List[zio.aws.connectcases.model.FieldError.ReadOnly]
    def fields: List[zio.aws.connectcases.model.GetFieldResponse.ReadOnly]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldError.ReadOnly
    ]] = ZIO.succeed(errors)
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.GetFieldResponse.ReadOnly
    ]] = ZIO.succeed(fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.BatchGetFieldResponse
  ) extends zio.aws.connectcases.model.BatchGetFieldResponse.ReadOnly {
    override val errors: List[zio.aws.connectcases.model.FieldError.ReadOnly] =
      impl
        .errors()
        .asScala
        .map { item =>
          zio.aws.connectcases.model.FieldError.wrap(item)
        }
        .toList
    override val fields
        : List[zio.aws.connectcases.model.GetFieldResponse.ReadOnly] = impl
      .fields()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.GetFieldResponse.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.BatchGetFieldResponse
  ): zio.aws.connectcases.model.BatchGetFieldResponse.ReadOnly = new Wrapper(
    impl
  )
}
