package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.DomainId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetFieldRequest(
    domainId: DomainId,
    fields: Iterable[zio.aws.connectcases.model.FieldIdentifier]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.BatchGetFieldRequest = {
    import BatchGetFieldRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.BatchGetFieldRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.BatchGetFieldRequest.ReadOnly =
    zio.aws.connectcases.model.BatchGetFieldRequest.wrap(buildAwsValue())
}
object BatchGetFieldRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.BatchGetFieldRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.BatchGetFieldRequest =
      zio.aws.connectcases.model.BatchGetFieldRequest(
        domainId,
        fields.map { item =>
          item.asEditable
        }
      )
    def domainId: DomainId
    def fields: List[zio.aws.connectcases.model.FieldIdentifier.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldIdentifier.ReadOnly
    ]] = ZIO.succeed(fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.BatchGetFieldRequest
  ) extends zio.aws.connectcases.model.BatchGetFieldRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val fields
        : List[zio.aws.connectcases.model.FieldIdentifier.ReadOnly] = impl
      .fields()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.FieldIdentifier.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.BatchGetFieldRequest
  ): zio.aws.connectcases.model.BatchGetFieldRequest.ReadOnly = new Wrapper(
    impl
  )
}
